/*
 * Decompiled with CFR 0.152.
 */
package >org.mule.modules.edi.base.1.2.2.lib;

import >org.mule.modules.edi.base.1.2.2.lib.BaseEdiModule;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.util.Map;
import org.mule.api.MuleEvent;

public class TransmissionSupport {
    public static final String B2B_TRANSMISSION_SESSION_FLOW_VARIABLE_KEY = "b2bTransmissionSession";
    private final BaseEdiModule baseModule;
    private Factory<Transmission> transmissionFactory;

    TransmissionSupport(BaseEdiModule module, Factory<Transmission> factory) {
        this.baseModule = module;
        this.transmissionFactory = factory;
    }

    public Transmission newTransmission() {
        return (Transmission)this.transmissionFactory.create();
    }

    public TransmissionSession trackInboundTransmission(MuleEvent muleEvent, byte[] payload, Map<String, Object> parsedContent, TransmissionType transmissionType) throws B2BProviderException {
        Transmission transmission = (Transmission)this.transmissionFactory.create();
        String filename = (String)muleEvent.getMessage().getInboundProperty("originalFilename");
        if (filename != null) {
            transmission.put((Object)"filename", (Object)filename);
        }
        transmission.put((Object)"content", (Object)payload);
        transmission.put((Object)"edi", parsedContent);
        return this.trackTransmission(this.baseModule.b2bProvider, muleEvent, Direction.INBOUND, transmission, transmissionType);
    }

    public TransmissionSession trackTransmission(B2BProvider b2bProvider, MuleEvent muleEvent, Direction direction, Transmission transmission, TransmissionType transmissionType) throws B2BProviderException {
        TransmissionSession transmissionSession = (TransmissionSession)muleEvent.getMessage().getInvocationProperty(B2B_TRANSMISSION_SESSION_FLOW_VARIABLE_KEY);
        Factory transmissionContextFactory = b2bProvider.getFactoryResolver().getFactory(TransmissionContext.class);
        TransmissionContext transmissionContext = (TransmissionContext)transmissionContextFactory.create();
        transmissionContext.setMuleEvent(muleEvent);
        transmissionContext.setTransmissionSession(transmissionSession);
        return b2bProvider.writeTransmission(direction, transmission, transmissionContext, transmissionType);
    }
}

